#!/bin/bash

# Set the base directory
BASE_DIR="/etc/virtual"

# Change to the base directory
cd "$BASE_DIR" || { echo "Failed to change directory to $BASE_DIR"; exit 1; }

# Iterate through all directories
for dir in */; do
  # Remove the trailing slash from the directory name
  dir=${dir%/}

  # Check if the directory has an _off counterpart
  if [[ -d "${dir}_off" ]]; then
    # Check if the non-_off directory exists
    if [[ -d "$dir" ]]; then
      echo "Deleting directory: $dir"
      # Attempt to delete the directory and log any errors
      rm -rf "$dir" 2>>error_log.txt
      # Verify if the directory is deleted
      if [[ -d "$dir" ]]; then
        echo "Failed to delete directory: $dir" >>error_log.txt
      else
        echo "Successfully deleted directory: $dir"
      fi
    fi
  fi
done

echo "Cleanup completed. Check error_log.txt for any issues."
