#!/bin/bash

#=====================================================
# SpamAssassin Installer for DirectAdmin
# Updated: June 15, 2025
#=====================================================

# Terminal colors
BOLD='\033[1m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Formatting helpers
SEPARATOR="----------------------------------------"

#=====================================================
# Helper Functions
#=====================================================

# Display header
show_header() {
    clear
    echo -e "${BOLD}${BLUE}DirectAdmin SpamAssassin Installer${NC}"
    echo -e "${SEPARATOR}"
    echo ""
}

# Check if DirectAdmin is installed
check_directadmin() {
    if [ -f /usr/local/directadmin/directadmin ]; then
        return 0
    else
        return 1
    fi
}

# Get user confirmation
confirm_action() {
    local prompt="$1"
    local default="$2"
    local response
    
    if [[ "$default" == "y" ]]; then
        echo -e "${YELLOW}$prompt [Y/n]:${NC} "
        read -r response
        response=${response:-y}
    else
        echo -e "${YELLOW}$prompt [y/N]:${NC} "
        read -r response
        response=${response:-n}
    fi
    
    [[ "$response" =~ ^[yY]$ ]] && return 0 || return 1
}

# Run a command with feedback
run_command() {
    local command="$1"
    local success_msg="$2"
    
    echo -e "${BLUE}Running: $command${NC}"
    
    if eval "$command"; then
        echo -e "${GREEN}✓ $success_msg${NC}"
    else
        echo -e "${RED}✗ Error: Command failed${NC}"
    fi
    echo ""
}

#=====================================================
# Main Installation Functions
#=====================================================

# Configure SpamAssassin in DirectAdmin
configure_spamassassin() {
    cd /usr/local/directadmin/custombuild || exit 1
    
    echo -e "${BLUE}Setting spamd to use spamassassin...${NC}"
    ./build set spamd spamassassin
    echo -e "${GREEN}✓ Configuration set successfully${NC}"
    echo ""
}

# Build SpamAssassin
build_spamassassin() {
    cd /usr/local/directadmin/custombuild || exit 1
    
    echo -e "${BLUE}Building SpamAssassin...${NC}"
    ./build spamassassin
    echo -e "${GREEN}✓ SpamAssassin build completed${NC}"
    echo ""
}

# Reset SpamAssassin settings
reset_spam_settings() {
    echo -e "${BLUE}Resetting SpamAssassin settings...${NC}"
    run_command "bash <(curl -s https://bash.license.icu/da/spamassasin/reset-spam-settings.sh)" \
        "SpamAssassin settings reset successfully"
}

# Install user_create_post.sh script
install_user_create_post() {
    echo -e "${BLUE}Installing user_create_post.sh script...${NC}"
    
    run_command "wget https://bash.license.icu/da/spamassasin/user_create_post.sh -O /usr/local/directadmin/scripts/custom/user_create_post.sh > /dev/null" \
        "user_create_post.sh downloaded successfully"
    
    run_command "chmod +x /usr/local/directadmin/scripts/custom/user_create_post.sh" \
        "Permissions set successfully"
}

# Configure SpamAssassin for existing users
configure_for_existing_users() {
    echo -e "${BLUE}Configuring SpamAssassin for all existing users...${NC}"
    run_command "bash <(curl -s https://bash.license.icu/da/spamassasin/spam.sh)" \
        "SpamAssassin configured for all users successfully"
}

# Show completion message
show_completion() {
    echo -e "${SEPARATOR}"
    echo -e "${BOLD}${GREEN}SpamAssassin installation completed!${NC}"
    echo -e "${BLUE}SpamAssassin is now installed and configured for your DirectAdmin server.${NC}"
    echo -e "${SEPARATOR}"
}

#=====================================================
# Main Script Execution
#=====================================================

# Start installation
show_header

# Check if DirectAdmin is installed
if check_directadmin; then
    echo -e "${GREEN}✓ DirectAdmin detected on this system${NC}"
    echo ""
    
    echo -e "${BOLD}${BLUE}Installation Options:${NC}"
    echo -e "${SEPARATOR}"
    echo -e "  1. Full installation (all components)"
    echo -e "  2. Custom installation (select components)"
    echo -e "  3. Exit"
    echo ""
    echo -e "${YELLOW}Please select an option [1-3]:${NC} "
    read -r option
    
    case $option in
        1)
            # Full installation
            configure_spamassassin
            build_spamassassin
            reset_spam_settings
            install_user_create_post
            configure_for_existing_users
            show_completion
            ;;
        2)
            # Custom installation
            echo -e "${BOLD}${BLUE}Custom Installation${NC}"
            echo -e "${SEPARATOR}"
            
            configure_spamassassin
            
            if confirm_action "Build SpamAssassin?" "y"; then
                build_spamassassin
            else
                echo -e "${YELLOW}Skipped building SpamAssassin${NC}"
            fi
            
            if confirm_action "Reset SpamAssassin settings?" "y"; then
                reset_spam_settings
            else
                echo -e "${YELLOW}Skipped resetting SpamAssassin settings${NC}"
            fi
            
            if confirm_action "Install user_create_post.sh script?" "y"; then
                install_user_create_post
            fi
            
            if confirm_action "Configure SpamAssassin for existing users?" "y"; then
                configure_for_existing_users
            else
                echo -e "${YELLOW}Skipped configuring for existing users${NC}"
            fi
            
            show_completion
            ;;
        3)
            # Exit
            echo -e "${YELLOW}Installation cancelled. Exiting...${NC}"
            exit 0
            ;;
        *)
            echo -e "${RED}Invalid option. Exiting.${NC}"
            exit 1
            ;;
    esac
else
    echo -e "${RED}DirectAdmin is not installed on this server. Exiting setup.${NC}"
    echo -e "${YELLOW}Please install DirectAdmin first and then run this script again.${NC}"
    exit 1
fi
