#!/bin/sh

# Function to rebuild the /etc/virtual/domain.com directory for a given domain and user
rebuild_virtual_directory() {
    DOMAIN=$1
    USER=$2
    VIRTUAL_DIR="/etc/virtual/$DOMAIN"

    # Check if the virtual directory exists, if not, create it
    if [ ! -d "$VIRTUAL_DIR" ]; then
        mkdir -p "$VIRTUAL_DIR"
    fi

    # Navigate to the virtual directory
    cd "$VIRTUAL_DIR"

    # Create and populate necessary files if they are missing
    if [ ! -f aliases ]; then
        echo "$USER: $USER" > aliases
        echo "*: :fail:" >> aliases
        chown mail:mail aliases
    fi
    [ ! -f autoresponder.conf ] && touch autoresponder.conf && chown mail:mail autoresponder.conf
    [ ! -f filter ] && touch filter && chown mail:mail filter
    [ ! -f filter.conf ] && touch filter.conf && chown mail:mail filter.conf
    [ ! -f passwd ] && touch passwd && chown mail:mail passwd
    [ ! -f quota ] && touch quota && chown mail:mail quota
    [ ! -f vacation.conf ] && touch vacation.conf && chown mail:mail vacation.conf
    [ ! -f filter.lock ] && touch filter.lock && chown mail:mail filter.lock

    # Set ownership of the directory
    chown mail:mail .

    # Create majordomo directory with appropriate permissions if missing
    if [ ! -d majordomo ]; then
        mkdir -p majordomo
        chmod 751 majordomo
        chown majordomo:daemon majordomo
    fi

    # Create reply directory with appropriate permissions if missing
    if [ ! -d reply ]; then
        mkdir -p reply
        chmod 700 reply
        chown mail:mail reply
    fi

    echo "Rebuild of /etc/virtual/$DOMAIN for user $USER complete."
}

# Loop through each user in the DirectAdmin users directory
for u in `ls /usr/local/directadmin/data/users`; do
{
    # Loop through each domain listed in the user's domains.list file
    for d in `cat /usr/local/directadmin/data/users/$u/domains.list`; do
    {
        if [ ! -d "/etc/virtual/$d" ]; then
            echo "Processing domain $d for user $u..."
            rebuild_virtual_directory $d $u
        fi
    }
    done;
}
done;
