#!/bin/sh

# Colors for output
GREEN='\033[0;32m'
NC='\033[0m' # No Color

# Iterate through all users' home directories
for user_home in /home/*; do
  # Extract the username from the home directory path
  username=$(basename "$user_home")

  # Define the path to the user_prefs file
  UP="$user_home/.spamassassin/user_prefs"

  # Check if the user_prefs file exists
  if [ -f "$UP" ]; then
    # Empty the user_prefs file
    > "$UP"
    echo "user_prefs file for user $username has been emptied."
  else
    echo "user_prefs file does not exist for user $username."
  fi
done

# Display success message
echo ""
echo -e "${GREEN}==================================================${NC}"
echo -e "${GREEN}   SpamAssassin settings have been reset successfully!${NC}"
echo -e "${GREEN}==================================================${NC}"

exit 0;
