#!/bin/bash

# DNS Zone File Sync Script
# Uses sshpass for password authentication

REMOTE_HOST="root@dns2.tanzaniaservers.com"
REMOTE_PORT="7162"
LOCAL_DIR="/var/named/"
REMOTE_DIR="/var/named/"

# Password file location - store password securely
PASSWORD_FILE="/etc/dns-sync/password"

# Check if sshpass is installed
if ! command -v sshpass &> /dev/null; then
    echo "Error: sshpass is not installed. Please install it first."
    echo "On Ubuntu/Debian: sudo apt-get install sshpass"
    echo "On CentOS/RHEL: sudo yum install sshpass"
    exit 1
fi

# Check if password file exists
if [ ! -f "$PASSWORD_FILE" ]; then
    echo "Error: Password file not found at $PASSWORD_FILE"
    echo "Please create the file with the SSH password"
    exit 1
fi

# Read password from file
PASSWORD=$(cat "$PASSWORD_FILE")

# Perform rsync with sshpass
sshpass -p "$PASSWORD" rsync -avz -e "ssh -p $REMOTE_PORT -o StrictHostKeyChecking=no" \
    "$LOCAL_DIR" "$REMOTE_HOST:$REMOTE_DIR"

# Check exit status
if [ $? -eq 0 ]; then
    echo "$(date): DNS zone files synchronized successfully"
    exit 0
else
    echo "$(date): Error: DNS sync failed"
    exit 1
fi