#!/bin/bash

# Define ANSI color codes
GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m' # No Color

cpanelFile="/var/cpanel/dnsonly"
directAdminFile="/usr/local/directadmin/directadmin"

if [ -e "$cpanelFile" ]; then
    echo -e "${GREEN}cPanel DNS Only detected.${NC}"
    echo ""
    # Command to install cPanel
    bash <(curl -s https://bash.license.icu/dns/cpanel-only/install-cpanel.sh)
elif [ -e "$directAdminFile" ]; then
    echo -e "${GREEN}DirectAdmin control panel detected.${NC}"
    echo ""
    # Command to install DirectAdmin
    bash <(curl -s https://bash.license.icu/dns/directadmin/install-directadmin.sh)
else
    echo -e "${RED}No supported control panel found.${NC}"
    # Handle the case where no supported control panel is detected
fi
