#!/bin/bash

# Simple DNS installer menu
# Lets you choose between:
# 1) cPanel DNS-only management installer
# 2) cPanel DNS sync service installer

GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m' # No Color

# Remote installer URLs
CPANEL_INSTALLER="https://bash.license.icu/dns/cpanel-only/install-cpanel.sh"
SYNC_INSTALLER="https://bash.license.icu/dns/cpanelsync/install-dns-sync.sh"

while true; do
    echo ""
    echo "DNS Installer Menu"
    echo "=================="
    echo "1. Install cPanel DNS-only management (install-cpanel.sh)"
    echo "2. Install DNS sync service (install-dns-sync.sh)"
    echo "3. Exit"
    echo ""
    read -p "Choose an option (1-3): " choice

    case "$choice" in
        1)
            echo -e "${GREEN}Running cPanel DNS installer...${NC}"
            bash <(curl -s "$CPANEL_INSTALLER")
            ;;
        2)
            echo -e "${GREEN}Running DNS sync installer...${NC}"
            bash <(curl -s "$SYNC_INSTALLER")
            ;;
        3)
            echo "Exiting."
            exit 0
            ;;
        *)
            echo -e "${RED}Invalid choice. Please select 1, 2, or 3.${NC}"
            ;;
    esac

done