#!/bin/bash

source /opt/yatosha-dns/config.sh

# Get domain from DirectAdmin environment variables
# Support both lowercase 'domain' (dns_delete_post) and uppercase 'DOMAIN' (some contexts)
da_domain=$( env | awk -F= '/^(domain|DOMAIN)=/ { print $2; exit }' )

# Validate required variables
if [ -z "$da_domain" ]; then
    $DEBUG && echo "$(date '+%b %e %T') ERROR: Missing domain/DOMAIN environment variable" >> $LOGFILE
    exit 1
fi

# Filter out system domains and unwanted domains
case "$da_domain" in
    localhost|*.local|*.localdomain|*.internal)
        $DEBUG && echo "$(date '+%b %e %T') SKIP: System domain $da_domain" >> $LOGFILE
        exit 0
        ;;
    *)
        # Process regular domains
        ;;
esac

# Execute DNS delete immediately for DirectAdmin feedback
if [ "$time" -eq 0 ]; then
    # Immediate execution
    $DEBUG && echo "$(date '+%b %e %T') EXECUTING: DNS delete for $da_domain" >> $LOGFILE
    /opt/yatosha-dns/yatosha-dns.sh delete "${da_domain}"
    exit_code=$?
    if [ $exit_code -eq 0 ]; then
        $DEBUG && echo "$(date '+%b %e %T') SUCCESS: DNS delete for $da_domain" >> $LOGFILE
    else
        $DEBUG && echo "$(date '+%b %e %T') FAILED: DNS delete for $da_domain with exit code $exit_code" >> $LOGFILE
    fi
    exit $exit_code
else
    # Delayed execution using at command
    task_file="/tmp/yatosha-dns-delete-$$-$(date +%s).task"
    echo "/opt/yatosha-dns/yatosha-dns.sh delete ${da_domain}" > "$task_file"
    
    # Schedule the task
    /usr/bin/at now + $time minutes < "$task_file"
    
    # Clean up task file
    rm -f "$task_file"
    
    $DEBUG && echo "$(date '+%b %e %T') QUEUED: DNS delete for $da_domain" >> $LOGFILE
fi
